import time
from tqdm import tqdm
from dataloader_seq import DataLoaderSeq

if __name__ == "__main__":
    dl = DataLoaderSeq(
        data_dir="./imagenette2",
        # data_dir="./ffhq",
        batch_size=64,
        image_size=(320, 320),
        drop_last=True,
        seed=1337,
    )

    t0 = time.perf_counter()
    total = 0
    for batch in tqdm(dl, desc="Training", unit="batch"):
        # Simulación de step del entrenamiento
        time.sleep(0.05)
        total += len(batch)

    dt = time.perf_counter() - t0
    print(f"\nEpoch done in {dt:.3f}s. Total images: {total} Throughput: {total/dt:.1f} img/s")
